
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE FullSizeAutoRefreshButtonArea.js -------------------------------------------------------->

FullSizeAutoRefreshButtonArea.prototype = new AreaBase();
function FullSizeAutoRefreshButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeAutoRefreshButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		FullSizeHelper.EventFullSizeCommand.Post(new FullSizeCommandArgs(SfFullSizeCommandType.CheckBoxToggle));
	}
}

// ENDFILE FullSizeAutoRefreshButtonArea.js ---------------------------------------------------------->

// BEGINFILE FullSizeCloseButtonArea.js -------------------------------------------------------------->

FullSizeCloseButtonArea.prototype = new AreaBase();
function FullSizeCloseButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeCloseButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		top.close();
	}
}

// ENDFILE FullSizeCloseButtonArea.js ---------------------------------------------------------------->

// BEGINFILE FullSizeNextSlideButtonArea.js ---------------------------------------------------------->

FullSizeNextSlideButtonArea.prototype = new AreaBase();
function FullSizeNextSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeNextSlideButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.InitializeButtonState();
		this.AddEventHandlers();
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers called");
		this.FullSizeStatusChangeEventHandler = new SfEventHandler("FSNSBA.FullSizeStatusChangeEventHandler");
		this.FullSizeStatusChangeEventHandler.MethodName = "OnFullSizeStatusChange";
		this.FullSizeStatusChangeEventHandler.Container = this.Container;
		FullSizeHelper.EventFullSizeStatusChange.AddHandler(this.FullSizeStatusChangeEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers called");
		FullSizeHelper.EventFullSizeStatusChange.RemoveHandler(this.FullSizeStatusChangeEventHandler);
	}
	
	this.OnClick = function()
	{
		this.Debug("Next Slide Handler called");
		FullSizeHelper.EventFullSizeCommand.Post(new FullSizeCommandArgs(SfFullSizeCommandType.NextSlide));
	}
	
	this.OnFullSizeStatusChange = function()
	{
		this.Debug("OnFullSizeStatusChange called");
		this.HandleButtonState(FullSizeHelper.CurrentSlideNumber);	
	}
	
	this.InitializeButtonState = function()
	{
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			this.button.Enable(false);
			return;
		}
		this.HandleButtonState(mainHelper.CurrentSlideNumber);	
	}
		
	this.HandleButtonState = function(currentSlideNumber)
	{
		this.Debug("HandleButtonState called, CurrentSlideNumber: " + currentSlideNumber);

		if (currentSlideNumber == -1)
		{
			this.Debug("image not initialized");
			this.button.Enable(false);
			return;
		}
		
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			this.button.Enable(false);
			return;
		}

		var status = FullSizeHelper.GetPresentationStatus();
		if (status == null)
		{
			this.Debug("don't know the status");
			this.button.Enable(false);
			return;
		}
		if (status == PresentationStatus.CaptureInProgress)
		{
			this.Debug("live so disabling");
			this.button.Enable(false);
			return;
		}
		
		var maxSlide = mainHelper.MaxSlideTimings;
		if (!maxSlide)
		{
			this.Debug("could not find maxSlide");
			this.button.Enable(false);
			return;
		}

		if (currentSlideNumber < maxSlide)
		{
			this.button.Enable(true);
		}
		else
		{
			this.button.Enable(false);
		}
	}
}

// ENDFILE FullSizeNextSlideButtonArea.js ------------------------------------------------------------>

// BEGINFILE FullSizePreviousSlideButtonArea.js ------------------------------------------------------>

FullSizePreviousSlideButtonArea.prototype = new AreaBase();
function FullSizePreviousSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizePreviousSlideButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.InitializeButtonState();
		this.AddEventHandlers();
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers called");
		this.FullSizeStatusChangeEventHandler = new SfEventHandler("FSPSBA.FullSizeStatusChangeEventHandler");
		this.FullSizeStatusChangeEventHandler.MethodName = "OnFullSizeStatusChange";
		this.FullSizeStatusChangeEventHandler.Container = this.Container;
		FullSizeHelper.EventFullSizeStatusChange.AddHandler(this.FullSizeStatusChangeEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers called");
		FullSizeHelper.EventFullSizeStatusChange.RemoveHandler(this.FullSizeStatusChangeEventHandler);
	}
	
	this.OnClick = function()
	{
		this.Debug("Previous Slide Handler called");
		FullSizeHelper.EventFullSizeCommand.Post(new FullSizeCommandArgs(SfFullSizeCommandType.PreviousSlide));
	}
	
	this.OnFullSizeStatusChange = function()
	{
		this.Debug("OnFullSizeStatusChange called");
		this.HandleButtonState(FullSizeHelper.CurrentSlideNumber);	
	}
	
	this.InitializeButtonState = function()
	{
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			this.button.Enable(false);
			return;
		}
		this.HandleButtonState(mainHelper.CurrentSlideNumber);	
	}
		
	this.HandleButtonState = function(currentSlideNumber)
	{
		this.Debug("HandleButtonState called, CurrentSlideNumber: " + currentSlideNumber);

		if (currentSlideNumber == -1)
		{
			this.Debug("image not initialized");
			this.button.Enable(false);
			return;
		}
		
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			this.button.Enable(false);
			return;
		}

		var status = FullSizeHelper.GetPresentationStatus();
		if (status == null)
		{
			this.Debug("don't know the status");
			this.button.Enable(false);
			return;
		}
		if (status == PresentationStatus.CaptureInProgress)
		{
			this.Debug("live so disabling");
			this.button.Enable(false);
			return;
		}
	
		if (currentSlideNumber > 1)
		{
			this.button.Enable(true);
		}
		else
		{
			this.button.Enable(false);
		}
	}
}

// ENDFILE FullSizePreviousSlideButtonArea.js -------------------------------------------------------->

// BEGINFILE FullSizeRefreshButtonArea.js ------------------------------------------------------------>

FullSizeRefreshButtonArea.prototype = new AreaBase();
function FullSizeRefreshButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeRefreshButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		FullSizeHelper.EventFullSizeCommand.Post(new FullSizeCommandArgs(SfFullSizeCommandType.Refresh));
	}
}

// ENDFILE FullSizeRefreshButtonArea.js -------------------------------------------------------------->

// BEGINFILE FullSizePlayFromSlideButtonArea.js ------------------------------------------------------------>

FullSizePlayFromSlideButtonArea.prototype = new AreaBase();
function FullSizePlayFromSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizePlayFromSlideButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		FullSizeHelper.NavigateToSlide();
	}
}

// ENDFILE FullSizePlayFromSlideButtonArea.js -------------------------------------------------------------->
